"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.workerBin = exports.observer = exports.parseScalabilityMode = exports.version = exports.types = void 0;
exports.createWorker = createWorker;
exports.getSupportedRtpCapabilities = getSupportedRtpCapabilities;
const Logger_1 = require("./Logger");
const enhancedEvents_1 = require("./enhancedEvents");
const Worker_1 = require("./Worker");
Object.defineProperty(exports, "workerBin", { enumerable: true, get: function () { return Worker_1.workerBin; } });
const utils = require("./utils");
const supportedRtpCapabilities_1 = require("./supportedRtpCapabilities");
const types = require("./types");
exports.types = types;
/**
 * Expose mediasoup version.
 */
// eslint-disable-next-line @typescript-eslint/no-require-imports
exports.version = require('../../package.json').version;
/**
 * Expose parseScalabilityMode() function.
 */
var scalabilityModes_1 = require("./scalabilityModes");
Object.defineProperty(exports, "parseScalabilityMode", { enumerable: true, get: function () { return scalabilityModes_1.parse; } });
const observer = new enhancedEvents_1.EnhancedEventEmitter();
exports.observer = observer;
const logger = new Logger_1.Logger();
/**
 * Create a Worker.
 */
async function createWorker({ logLevel = 'error', logTags, rtcMinPort = 10000, rtcMaxPort = 59999, dtlsCertificateFile, dtlsPrivateKeyFile, libwebrtcFieldTrials, disableLiburing, appData, } = {}) {
    logger.debug('createWorker()');
    if (appData && typeof appData !== 'object') {
        throw new TypeError('if given, appData must be an object');
    }
    const worker = new Worker_1.Worker({
        logLevel,
        logTags,
        rtcMinPort,
        rtcMaxPort,
        dtlsCertificateFile,
        dtlsPrivateKeyFile,
        libwebrtcFieldTrials,
        disableLiburing,
        appData,
    });
    return new Promise((resolve, reject) => {
        worker.on('@success', () => {
            // Emit observer event.
            observer.safeEmit('newworker', worker);
            resolve(worker);
        });
        worker.on('@failure', reject);
    });
}
/**
 * Get a cloned copy of the mediasoup supported RTP capabilities.
 */
function getSupportedRtpCapabilities() {
    return utils.clone(supportedRtpCapabilities_1.supportedRtpCapabilities);
}
