"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.SrtpParametersT = exports.SrtpParameters = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const srtp_crypto_suite_1 = require("../../fbs/srtp-parameters/srtp-crypto-suite");
class SrtpParameters {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsSrtpParameters(bb, obj) {
        return (obj || new SrtpParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsSrtpParameters(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new SrtpParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    cryptoSuite() {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : srtp_crypto_suite_1.SrtpCryptoSuite.AEAD_AES_256_GCM;
    }
    keyBase64(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    static startSrtpParameters(builder) {
        builder.startObject(2);
    }
    static addCryptoSuite(builder, cryptoSuite) {
        builder.addFieldInt8(0, cryptoSuite, srtp_crypto_suite_1.SrtpCryptoSuite.AEAD_AES_256_GCM);
    }
    static addKeyBase64(builder, keyBase64Offset) {
        builder.addFieldOffset(1, keyBase64Offset, 0);
    }
    static endSrtpParameters(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 6); // key_base64
        return offset;
    }
    static createSrtpParameters(builder, cryptoSuite, keyBase64Offset) {
        SrtpParameters.startSrtpParameters(builder);
        SrtpParameters.addCryptoSuite(builder, cryptoSuite);
        SrtpParameters.addKeyBase64(builder, keyBase64Offset);
        return SrtpParameters.endSrtpParameters(builder);
    }
    unpack() {
        return new SrtpParametersT(this.cryptoSuite(), this.keyBase64());
    }
    unpackTo(_o) {
        _o.cryptoSuite = this.cryptoSuite();
        _o.keyBase64 = this.keyBase64();
    }
}
exports.SrtpParameters = SrtpParameters;
class SrtpParametersT {
    cryptoSuite;
    keyBase64;
    constructor(cryptoSuite = srtp_crypto_suite_1.SrtpCryptoSuite.AEAD_AES_256_GCM, keyBase64 = null) {
        this.cryptoSuite = cryptoSuite;
        this.keyBase64 = keyBase64;
    }
    pack(builder) {
        const keyBase64 = (this.keyBase64 !== null ? builder.createString(this.keyBase64) : 0);
        return SrtpParameters.createSrtpParameters(builder, this.cryptoSuite, keyBase64);
    }
}
exports.SrtpParametersT = SrtpParametersT;
