"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecvStatsT = exports.RecvStats = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const bitrate_by_layer_1 = require("../../fbs/rtp-stream/bitrate-by-layer");
const stats_1 = require("../../fbs/rtp-stream/stats");
class RecvStats {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsRecvStats(bb, obj) {
        return (obj || new RecvStats()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsRecvStats(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new RecvStats()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    base(obj) {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? (obj || new stats_1.Stats()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    jitter() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    packetCount() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.readUint64(this.bb_pos + offset) : BigInt('0');
    }
    byteCount() {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? this.bb.readUint64(this.bb_pos + offset) : BigInt('0');
    }
    bitrate() {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    bitrateByLayer(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? (obj || new bitrate_by_layer_1.BitrateByLayer()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    bitrateByLayerLength() {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    static startRecvStats(builder) {
        builder.startObject(6);
    }
    static addBase(builder, baseOffset) {
        builder.addFieldOffset(0, baseOffset, 0);
    }
    static addJitter(builder, jitter) {
        builder.addFieldInt32(1, jitter, 0);
    }
    static addPacketCount(builder, packetCount) {
        builder.addFieldInt64(2, packetCount, BigInt('0'));
    }
    static addByteCount(builder, byteCount) {
        builder.addFieldInt64(3, byteCount, BigInt('0'));
    }
    static addBitrate(builder, bitrate) {
        builder.addFieldInt32(4, bitrate, 0);
    }
    static addBitrateByLayer(builder, bitrateByLayerOffset) {
        builder.addFieldOffset(5, bitrateByLayerOffset, 0);
    }
    static createBitrateByLayerVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startBitrateByLayerVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static endRecvStats(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 4); // base
        builder.requiredField(offset, 14); // bitrate_by_layer
        return offset;
    }
    static createRecvStats(builder, baseOffset, jitter, packetCount, byteCount, bitrate, bitrateByLayerOffset) {
        RecvStats.startRecvStats(builder);
        RecvStats.addBase(builder, baseOffset);
        RecvStats.addJitter(builder, jitter);
        RecvStats.addPacketCount(builder, packetCount);
        RecvStats.addByteCount(builder, byteCount);
        RecvStats.addBitrate(builder, bitrate);
        RecvStats.addBitrateByLayer(builder, bitrateByLayerOffset);
        return RecvStats.endRecvStats(builder);
    }
    unpack() {
        return new RecvStatsT((this.base() !== null ? this.base().unpack() : null), this.jitter(), this.packetCount(), this.byteCount(), this.bitrate(), this.bb.createObjList(this.bitrateByLayer.bind(this), this.bitrateByLayerLength()));
    }
    unpackTo(_o) {
        _o.base = (this.base() !== null ? this.base().unpack() : null);
        _o.jitter = this.jitter();
        _o.packetCount = this.packetCount();
        _o.byteCount = this.byteCount();
        _o.bitrate = this.bitrate();
        _o.bitrateByLayer = this.bb.createObjList(this.bitrateByLayer.bind(this), this.bitrateByLayerLength());
    }
}
exports.RecvStats = RecvStats;
class RecvStatsT {
    base;
    jitter;
    packetCount;
    byteCount;
    bitrate;
    bitrateByLayer;
    constructor(base = null, jitter = 0, packetCount = BigInt('0'), byteCount = BigInt('0'), bitrate = 0, bitrateByLayer = []) {
        this.base = base;
        this.jitter = jitter;
        this.packetCount = packetCount;
        this.byteCount = byteCount;
        this.bitrate = bitrate;
        this.bitrateByLayer = bitrateByLayer;
    }
    pack(builder) {
        const base = (this.base !== null ? this.base.pack(builder) : 0);
        const bitrateByLayer = RecvStats.createBitrateByLayerVector(builder, builder.createObjectOffsetList(this.bitrateByLayer));
        return RecvStats.createRecvStats(builder, base, this.jitter, this.packetCount, this.byteCount, this.bitrate, bitrateByLayer);
    }
}
exports.RecvStatsT = RecvStatsT;
